using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI.controls
{
    /// <summary>
    /// Summary description for PatientInfoToolbar.
    /// </summary>
    public class PatientInfoToolbar : GUI.controls.BaseControl
    {
        private readonly PatientInfoToolbarBase _patientInfoToolbarBase;
        private VbecsBaseForm _parentForm
        {
            get
            {
                return (VbecsBaseForm)this.FindForm();
            }
        }

        #region Controls

        private System.Windows.Forms.Button btnCurrentMeds;
        private System.Windows.Forms.Button btnBloodAvailability;
        private System.Windows.Forms.Button btnSpecialInstructions;
        private System.Windows.Forms.ToolTip ttToolTip;
        private System.Windows.Forms.Button btnRecentOrders;
        private System.Windows.Forms.Button btnTransfusionReactionHistory;
        private System.Windows.Forms.Button btnRecentTransfusionsIssues;
        private System.Windows.Forms.HelpProvider hlpHelpChm;
        private System.ComponentModel.IContainer components;

        #endregion

        #region Constructors/Destructors

        /// <summary>
        /// PatientInfoToolbar
        /// </summary>
        public PatientInfoToolbar()
        {
            // This call is required by the Windows.Forms Form Designer.
            InitializeComponent();

            _patientInfoToolbarBase = new PatientInfoToolbarBase();
            _patientInfoToolbarBase.UserActivity += _patientInfoToolbarBase_UserActivity;
            _patientInfoToolbarBase.PropertyChanged += _patientInfoToolbarBase_PropertyChanged;
#if !DESIGN
            this.hlpHelpChm.HelpNamespace = _patientInfoToolbarBase.HelpNamespace;
#endif
        }

        void _patientInfoToolbarBase_PropertyChanged(object sender, PropertyChangedEventArgs e)
        {
            if (e.PropertyName == _patientInfoToolbarBase.EnabledSIAndTRButtonPropName)
            {
                btnSpecialInstructions.Enabled = _patientInfoToolbarBase.EnabledSIAndTRButton;
            }
            else if (e.PropertyName == _patientInfoToolbarBase.EnabledBloodAvailButtonPropName)
            {
                btnBloodAvailability.Enabled = _patientInfoToolbarBase.EnabledBloodAvailButton;
            }
            else if (e.PropertyName == _patientInfoToolbarBase.EnabledRecentOrdersButtonPropName)
            {
                btnRecentOrders.Enabled = _patientInfoToolbarBase.EnabledRecentOrdersButton;
            }
            else if (e.PropertyName == _patientInfoToolbarBase.EnabledMedicationButtonPropName)
            {
                btnCurrentMeds.Enabled = _patientInfoToolbarBase.EnabledMedicationButton;
            }
            else if (e.PropertyName == _patientInfoToolbarBase.EnabledRecentTransfusionsIssuesButtonPropName)
            {
                btnRecentTransfusionsIssues.Enabled = _patientInfoToolbarBase.EnabledRecentTransfusionsIssuesButton;
            }
            else if (e.PropertyName == _patientInfoToolbarBase.EnabledTransfusionReactionHistoryButtonPropName)
            {
                btnTransfusionReactionHistory.Enabled = _patientInfoToolbarBase.EnabledTransfusionReactionHistoryButton;
            }
        }

        private void _patientInfoToolbarBase_UserActivity(object sender, EventArgs e)
        {
            this.OnUserActivity();
        }

        /// <summary> 
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }


        #endregion

        #region Component Designer generated code
        /// <summary> 
        /// Required method for Designer support - do not modify 
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(PatientInfoToolbar));
            this.btnCurrentMeds = new System.Windows.Forms.Button();
            this.btnBloodAvailability = new System.Windows.Forms.Button();
            this.btnSpecialInstructions = new System.Windows.Forms.Button();
            this.btnTransfusionReactionHistory = new System.Windows.Forms.Button();
            this.btnRecentTransfusionsIssues = new System.Windows.Forms.Button();
            this.btnRecentOrders = new System.Windows.Forms.Button();
            this.ttToolTip = new System.Windows.Forms.ToolTip(this.components);
            this.hlpHelpChm = new System.Windows.Forms.HelpProvider();
            this.SuspendLayout();
            // 
            // btnCurrentMeds
            // 
            this.btnCurrentMeds.AccessibleDescription = "Patient Medication Profile";
            this.btnCurrentMeds.AccessibleName = "Patient Medication Profile";
            this.btnCurrentMeds.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCurrentMeds.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.hlpHelpChm.SetHelpKeyword(this.btnCurrentMeds, "");
            this.btnCurrentMeds.Image = ((System.Drawing.Image)(resources.GetObject("btnCurrentMeds.Image")));
            this.btnCurrentMeds.Location = new System.Drawing.Point(78, 0);
            this.btnCurrentMeds.Name = "btnCurrentMeds";
            this.hlpHelpChm.SetShowHelp(this.btnCurrentMeds, false);
            this.btnCurrentMeds.Size = new System.Drawing.Size(24, 20);
            this.btnCurrentMeds.TabIndex = 3;
            this.ttToolTip.SetToolTip(this.btnCurrentMeds, PatientInfoToolbarBase.DISPLAY_MEDICATION_TOOLTIP);
            this.btnCurrentMeds.Click += new System.EventHandler(this.btnCurrentMeds_Click);
            // 
            // btnBloodAvailability
            // 
            this.btnBloodAvailability.AccessibleDescription = "Blood Availability";
            this.btnBloodAvailability.AccessibleName = "Blood Availability";
            this.btnBloodAvailability.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.hlpHelpChm.SetHelpKeyword(this.btnBloodAvailability, "");
            this.btnBloodAvailability.Image = ((System.Drawing.Image)(resources.GetObject("btnBloodAvailability.Image")));
            this.btnBloodAvailability.Location = new System.Drawing.Point(26, 0);
            this.btnBloodAvailability.Name = "btnBloodAvailability";
            this.hlpHelpChm.SetShowHelp(this.btnBloodAvailability, false);
            this.btnBloodAvailability.Size = new System.Drawing.Size(24, 20);
            this.btnBloodAvailability.TabIndex = 1;
            this.ttToolTip.SetToolTip(this.btnBloodAvailability, PatientInfoToolbarBase.DISPLAY_BLOOD_AVAIL_TOOLTIP);
            this.btnBloodAvailability.Click += new System.EventHandler(this.btnBloodAvailability_Click);
            // 
            // btnSpecialInstructions
            // 
            this.btnSpecialInstructions.AccessibleDescription = "Special Instructions";
            this.btnSpecialInstructions.AccessibleName = "Special Instructions";
            this.btnSpecialInstructions.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.hlpHelpChm.SetHelpKeyword(this.btnSpecialInstructions, "");
            this.btnSpecialInstructions.Image = ((System.Drawing.Image)(resources.GetObject("btnSpecialInstructions.Image")));
            this.btnSpecialInstructions.Location = new System.Drawing.Point(0, 0);
            this.btnSpecialInstructions.Name = "btnSpecialInstructions";
            this.hlpHelpChm.SetShowHelp(this.btnSpecialInstructions, false);
            this.btnSpecialInstructions.Size = new System.Drawing.Size(24, 20);
            this.btnSpecialInstructions.TabIndex = 0;
            this.ttToolTip.SetToolTip(this.btnSpecialInstructions, PatientInfoToolbarBase.DISPLAY_SI_AND_TR_TOOLTIP);
            this.btnSpecialInstructions.Click += new System.EventHandler(this.btnSpecialInstructions_Click);
            // 
            // btnTransfusionReactionHistory
            // 
            this.btnTransfusionReactionHistory.AccessibleDescription = "Transfusion Reaction History";
            this.btnTransfusionReactionHistory.AccessibleName = "Transfusion Reaction History";
            this.btnTransfusionReactionHistory.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnTransfusionReactionHistory.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.hlpHelpChm.SetHelpKeyword(this.btnTransfusionReactionHistory, "");
            this.btnTransfusionReactionHistory.Image = ((System.Drawing.Image)(resources.GetObject("btnTransfusionReactionHistory.Image")));
            this.btnTransfusionReactionHistory.Location = new System.Drawing.Point(130, 0);
            this.btnTransfusionReactionHistory.Name = "btnTransfusionReactionHistory";
            this.hlpHelpChm.SetShowHelp(this.btnTransfusionReactionHistory, false);
            this.btnTransfusionReactionHistory.Size = new System.Drawing.Size(24, 20);
            this.btnTransfusionReactionHistory.TabIndex = 5;
            this.ttToolTip.SetToolTip(this.btnTransfusionReactionHistory, PatientInfoToolbarBase.DISPLAY_TRANSFUSION_HISTORY_TOOLTIP);
            this.btnTransfusionReactionHistory.Click += new System.EventHandler(this.btnTransfusionReactionHistory_Click);
            // 
            // btnRecentTransfusionsIssues
            // 
            this.btnRecentTransfusionsIssues.AccessibleDescription = "Recent Transfusions and Issued Units";
            this.btnRecentTransfusionsIssues.AccessibleName = "Recent Transfusions and Issued Units";
            this.btnRecentTransfusionsIssues.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnRecentTransfusionsIssues.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.hlpHelpChm.SetHelpKeyword(this.btnRecentTransfusionsIssues, "");
            this.btnRecentTransfusionsIssues.Image = ((System.Drawing.Image)(resources.GetObject("btnRecentTransfusionsIssues.Image")));
            this.btnRecentTransfusionsIssues.Location = new System.Drawing.Point(104, 0);
            this.btnRecentTransfusionsIssues.Name = "btnRecentTransfusionsIssues";
            this.hlpHelpChm.SetShowHelp(this.btnRecentTransfusionsIssues, false);
            this.btnRecentTransfusionsIssues.Size = new System.Drawing.Size(24, 20);
            this.btnRecentTransfusionsIssues.TabIndex = 4;
            this.ttToolTip.SetToolTip(this.btnRecentTransfusionsIssues, PatientInfoToolbarBase.DISPLAY_RECENT_TRANSFUSION_ISSUE_TOOLTIP);
            this.btnRecentTransfusionsIssues.Click += new System.EventHandler(this.btnRecentTransfusionsIssues_Click);
            // 
            // btnRecentOrders
            // 
            this.btnRecentOrders.AccessibleDescription = "Recent Orders";
            this.btnRecentOrders.AccessibleName = "Recent Orders";
            this.btnRecentOrders.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.hlpHelpChm.SetHelpKeyword(this.btnRecentOrders, "");
            this.btnRecentOrders.Image = ((System.Drawing.Image)(resources.GetObject("btnRecentOrders.Image")));
            this.btnRecentOrders.Location = new System.Drawing.Point(52, 0);
            this.btnRecentOrders.Name = "btnRecentOrders";
            this.hlpHelpChm.SetShowHelp(this.btnRecentOrders, false);
            this.btnRecentOrders.Size = new System.Drawing.Size(24, 20);
            this.btnRecentOrders.TabIndex = 2;
            this.ttToolTip.SetToolTip(this.btnRecentOrders, PatientInfoToolbarBase.DISPLAY_RECENT_ORDERS_TOOLTIP);
            this.btnRecentOrders.Click += new System.EventHandler(this.btnRecentOrders_Click);
            // 
            // ttToolTip
            // 
            this.ttToolTip.ShowAlways = true;
            // 
            // PatientInfoToolbar
            // 
            this.Controls.Add(this.btnCurrentMeds);
            this.Controls.Add(this.btnBloodAvailability);
            this.Controls.Add(this.btnSpecialInstructions);
            this.Controls.Add(this.btnTransfusionReactionHistory);
            this.Controls.Add(this.btnRecentTransfusionsIssues);
            this.Controls.Add(this.btnRecentOrders);
            this.hlpHelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.Name = "PatientInfoToolbar";
            this.hlpHelpChm.SetShowHelp(this, true);
            this.Size = new System.Drawing.Size(154, 20);
            this.ResumeLayout(false);

        }
        #endregion


        #region Control Events

        /// <summary>
        /// Calls the event when special instructions and patient transfusion requirements button is being clicked
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnSpecialInstructions_Click(object sender, System.EventArgs e)
        {
            _patientInfoToolbarBase.OnSpecialInstructionsClick(_parentForm);
        }

        /// <summary>
        /// Calls the event when blood availability button is being clicked
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnBloodAvailability_Click(object sender, System.EventArgs e)
        {
            _patientInfoToolbarBase.OnBloodAvailabilityClick(_parentForm);
        }

        /// <summary>
        /// Calls the event when patient VBECS data button is being clicked
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnRecentOrders_Click(object sender, System.EventArgs e)
        {
            _patientInfoToolbarBase.OnRecentOrdersClick(_parentForm);
        }

        /// <summary>
        /// Calls the event when patient current medications button is being clicked
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnCurrentMeds_Click(object sender, System.EventArgs e)
        {
            _patientInfoToolbarBase.OnCurrentMedsClick(_parentForm);
        }

        /// <summary>
        /// Calls the event when patient transfusion history button is being clicked
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnRecentTransfusionsIssues_Click(object sender, System.EventArgs e)
        {
            _patientInfoToolbarBase.OnRecentTransfusionsIssuesClick(_parentForm);
        }

        /// <summary>
        /// Calls the event when patient clinical data button is being clicked
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnTransfusionReactionHistory_Click(object sender, System.EventArgs e)
        {
            _patientInfoToolbarBase.OnTransfusionReactionHistoryClick(_parentForm);
        }

        #endregion

        #region Properties

        /// <summary>
        /// The Guid of the container holing the toolbar (where any locks may have been created)
        /// Need this for child-form closing
        /// </summary>
        public System.Guid ParentFormInstanceGuid
        {
            get
            {
                return _patientInfoToolbarBase.ParentFormInstanceGuid;
            }
            set
            {
                _patientInfoToolbarBase.ParentFormInstanceGuid = value;
            }
        }

        /// <summary>
        /// Display tool bar as single or double row
        /// </summary>
        [
        Category("Appearance"),
        Description("Display tool bar as single or double row"),
        DefaultValue(true),
        Bindable(false),
        Browsable(true),
        ]
        public bool SingleRowDisplay
        {
            get
            {
                return _patientInfoToolbarBase.SingleRowDisplay;
            }
            set
            {
                _patientInfoToolbarBase.SingleRowDisplay = value;

                if (_patientInfoToolbarBase.SingleRowDisplay)
                {
                    this.Size = new Size(154, 20);
                }
                else
                {
                    this.Size = new Size(76, 42);
                }
            }
        }

        /// <summary>
        /// Indicates whether the SI (and) TR button is enabled
        /// </summary>
        [
        Category("Behavior"),
        Description("Indicates whether the SI & TR button is enabled"),
        DefaultValue(true),
        Bindable(false),
        Browsable(true),
        ]
        public bool EnabledSIAndTRButton
        {
            get
            {
                return _patientInfoToolbarBase.EnabledSIAndTRButton;
            }
            set
            {
                _patientInfoToolbarBase.EnabledSIAndTRButton = value;
            }
        }

        /// <summary>
        /// Indicates whether the blood availability button is enabled
        /// </summary>
        [
        Category("Behavior"),
        Description("Indicates whether the blood availability button is enabled"),
        DefaultValue(true),
        Bindable(false),
        Browsable(true),
        ]
        public bool EnabledBloodAvailButton
        {
            get
            {
                return _patientInfoToolbarBase.EnabledBloodAvailButton;
            }
            set
            {
                _patientInfoToolbarBase.EnabledBloodAvailButton = value;
            }
        }

        /// <summary>
        /// Indicates whether the Recent Orders button is enabled
        /// </summary>
        [
        Category("Behavior"),
        Description("Indicates whether the Recent Orders button is enabled"),
        DefaultValue(true),
        Bindable(false),
        Browsable(true),
        ]
        public bool EnabledRecentOrdersButton
        {
            get
            {
                return _patientInfoToolbarBase.EnabledRecentOrdersButton;
            }
            set
            {
                _patientInfoToolbarBase.EnabledRecentOrdersButton = value;
            }
        }

        /// <summary>
        /// Indicates whether the Medication Profile button is enabled
        /// </summary>
        [
        Category("Behavior"),
        Description("Indicates whether the Medication Profile button is enabled"),
        DefaultValue(true),
        Bindable(false),
        Browsable(true),
        ]
        public bool EnabledMedicationButton
        {
            get
            {
                return _patientInfoToolbarBase.EnabledMedicationButton;
            }
            set
            {
                _patientInfoToolbarBase.EnabledMedicationButton = value;
            }
        }

        /// <summary>
        /// Indicates whether the Recent Transfusios/Issued Units button is enabled
        /// </summary>
        [
        Category("Behavior"),
        Description("Indicates whether the Recent Transfusios/Issued Units button is enabled"),
        DefaultValue(true),
        Bindable(false),
        Browsable(true),
        ]
        public bool EnabledRecentTransfusionsIssuesButton
        {
            get
            {
                return _patientInfoToolbarBase.EnabledRecentTransfusionsIssuesButton;
            }
            set
            {
                _patientInfoToolbarBase.EnabledRecentTransfusionsIssuesButton = value;
            }
        }

        /// <summary>
        /// Indicates whether the Transfusion Reaction History button is enabled
        /// </summary>
        [
        Category("Behavior"),
        Description("Indicates whether the Transfusion Reaction History button is enabled"),
        DefaultValue(true),
        Bindable(false),
        Browsable(true),
        ]
        public bool EnabledTransfusionReactionHistoryButton
        {
            get
            {
                return _patientInfoToolbarBase.EnabledTransfusionReactionHistoryButton;
            }
            set
            {
                _patientInfoToolbarBase.EnabledTransfusionReactionHistoryButton = value;
            }
        }


        /// <summary>
        /// Current working Patient object
        /// </summary>
        public BOL.Patient Patient
        {
            get
            {
                return _patientInfoToolbarBase.Patient;
            }
            set
            {
                _patientInfoToolbarBase.Patient = value;
            }
        }
        #endregion

        /// <summary>
        /// EnableAllButtons
        /// </summary>
        /// <param name="enable"></param>
        public void EnableAllButtons(bool enable)
        {
            _patientInfoToolbarBase.EnableAllButtons(enable);
        }

    }
}
